#include "c4d_memory.h"
#include "c4d_general.h"
#include "c4d_tools.h"
#include "c4d_materialplugin.h"
#include "c4d_resource.h"

Bool MaterialData::Draw(PluginMaterial *mat, BaseObject *op, BaseTag *tag, BaseDraw *bd, BaseDrawHelp *bh)
{
	return TRUE;
}

LONG MaterialData::GetRenderInfo(PluginMaterial *mat)
{	
	return 0;
}

LONG MaterialData::InitRender(PluginMaterial *mat, InitRenderStruct *irs)
{
	return LOAD_OK;
}

void MaterialData::FreeRender(PluginMaterial *mat)
{
}

void MaterialData::InitCalculation(PluginMaterial *mat, VolumeData *vd, LONG type)
{
}

void MaterialData::Displace(PluginMaterial *mat, VolumeData *vd)
{
}

void MaterialData::ChangeNormal(PluginMaterial *mat, VolumeData *vd)
{
}

void MaterialData::CalcSurface(PluginMaterial *mat, VolumeData *vd)
{
}

void MaterialData::CalcTransparency(PluginMaterial *mat, VolumeData *vd)
{
}

void MaterialData::CalcAlpha(PluginMaterial *mat, VolumeData *vd)
{
}

void MaterialData::CalcVolumetric(PluginMaterial *mat, VolumeData *vd)
{
}

static void FillMaterialPlugin(MATERIALPLUGIN *np, DataAllocator *npalloc, LONG info, LONG disklevel, void *emulation)
{
	FillNodePlugin(np,info,npalloc,NULL,disklevel,emulation);

	np->Draw								= &MaterialData::Draw;
	np->GetRenderInfo				= &MaterialData::GetRenderInfo;
	np->InitRender					= &MaterialData::InitRender;
	np->FreeRender					= &MaterialData::FreeRender;
	np->InitCalculation			= &MaterialData::InitCalculation;
	np->Displace						= &MaterialData::Displace;
	np->ChangeNormal				= &MaterialData::ChangeNormal;
	np->CalcSurface					= &MaterialData::CalcSurface;
	np->CalcTransparency		= &MaterialData::CalcTransparency;
	np->CalcAlpha						= &MaterialData::CalcAlpha;
	np->CalcVolumetric			= &MaterialData::CalcVolumetric;
}

Bool RegisterMaterialPlugin(LONG id, const String &str, LONG info, DataAllocator *npalloc, const String &description, LONG disklevel, void *emulation)
{
	if (description.Content() && !RegisterDescription(id,description)) return FALSE;

	MATERIALPLUGIN np;
	ClearMem(&np,sizeof(np));
	FillMaterialPlugin(&np,npalloc,info,disklevel,emulation);
	return GeRegisterPlugin(C4DPL_MATERIAL,id,str,&np,sizeof(np));
}
